<?php

	/* Front end */
	function icons($name, $class='') {
		return '<svg class="icon'.(!empty($class)?' '.$class:'').'"><use xlink:href="#'.$name.'" /></svg>';
	}
	function icons_nb($nb) {
		$out = '';
		for ($i=1;$i<=5;$i++) {
			if ($i <= $nb) $out .= icons('star','icon-star');
			else if (intval(ceil($nb)) === $i) $out .= icons('star_half','icon-star-half');
			else $out .= icons('star_empty','icon-star-empty');
		}
		return $out;
	}

	function alink($href, $title, $blank=false) {
		return '<a href="'.$href.'" title="'.$title.'"'.($blank?' target="_blank"':'').'>'.$title.'</a>';
	}

	function gimg($src, $alt='', $width='', $height='') {
		return '<img width="'.$width.'" height="'.$height.'" src="'.$src.ts().'" alt="'.$alt.'">';
	}

	function ts() {
		return '?ts='.time();
		//return PROD ? '' : '?ts='.time();
	}
	
	function img_base64($name_img) {
		$path = ASSETS_IMG.$name_img;
		$type = pathinfo($path, PATHINFO_EXTENSION);
		$data = file_get_contents($path);
		$base64 = 'data:image/'.$type.';base64,'.base64_encode($data);
		return $base64;
	}
	
	function qr_code($url, $size='300x300', $color='000000') {
		return 'https://chart.googleapis.com/chart?chs='.$size.'&cht=qr&chl='.urlencode($url).'&choe=UTF-8&chco='.$color;
	}
	
	/* Back end */
	function post_to_array() {
		$datas = array();
		foreach ($_POST as $k => $p) {
			if (substr_count($k, 'submit') > 0) continue;
			$datas[$k] = $p; 
		}
		//var_dump($datas); die;
		return $datas;
	}

	function upload($files, $path='uploads/', $size=5000000, $type=array('.png', '.gif', '.jpg', '.jpeg')) {
		if (!empty($files)) { 
			//var_dump($files);
			$file_name = basename($files['name']);
			$file_size = $files['size'];
			$ext = strtolower(strrchr($file_name, '.'));

			if (!in_array($ext, $type)) return 'ERROR_UP_TYPE'; // check type ext
			if ($file_size > $size) return 'ERROR_UP_SIZE'; // check size
			return move_uploaded_file($files['tmp_name'], $path.$file_name) ? 'SUCCESS_UP' : 'ERROR_UP_FAIL'; // upload
		}
	}

	function go_die($loc) {
		header("Location: ".$loc); die;
	}
	
	function go_404() {
		header("Location: page_404.php"); die;
	}

	function get_pass_hashed($pass) {
		return hash('sha256', SALT.$pass.SALT);
	}
	
	function ob_html_compress($buf){
		$search = array(
			'/\>[^\S ]+/s',     // strip whitespaces after tags, except space
			'/[^\S ]+\</s',     // strip whitespaces before tags, except space
			'/(\s)+/s',         // shorten multiple whitespace sequences
			'/<!--(.|\s)*?-->/' // Remove HTML comments
		);
		$replace = array(
			'>',
			'<',
			'\\1',
			''
		);
		return preg_replace($search, $replace, $buf);
	}
	
	function check_get_num($get_name, $num) {
		return (!empty($_GET[$get_name]) && (int)$_GET[$get_name] === (int)$num) ? true : false;
	}
	
	function cut_text($input, $length, $ellipses = true, $strip_html = true) {
        //strip tags, if desired
        if ($strip_html) $input = strip_tags($input);
    
        //no need to trim, already shorter than trim length
        if (strlen($input) <= $length) return $input;
    
        //find last space within length
        $last_space = strrpos(substr($input, 0, $length), ' ');
        if ($last_space !== false) $trimmed_text = substr($input, 0, $last_space);
        else $trimmed_text = substr($input, 0, $length);

        if ($ellipses) $trimmed_text .= '...';
    
        return $trimmed_text;
    }
	
	function set_lang_session($array_lang) {
		if (in_array(strtolower($_GET['lang']),$array_lang)) {
			$key = array_search(strtolower($_GET['lang']), $array_lang);
			$key = intval($key);
			$_SESSION['lang'] = $array_lang[$key];
		} else {
			$_SESSION['lang'] = $array_lang[0];
		}
	}
	
	function is_mobile() {
		$useragent = $_SERVER['HTTP_USER_AGENT'];
		return preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4));
	}

	// YYYY-MM-DD
	function get_age ($date) {
		$date_a = explode(' ', $date);
		$date = $date_a[0];
		$birthDate = explode("-", $date);
		//var_dump($birthDate); die;
		$age = (date("md", date("U", mktime(0, 0, 0, $birthDate[2], $birthDate[1], $birthDate[0]))) > date("md")
			? ((date("Y") - $birthDate[0]) - 1)
			: (date("Y") - $birthDate[0]));
		return $age;
	}

	function slug($file) {
		$notAllowedChars = array('À','Á','Â','Ã','Ä','Å','Ç','È','É','Ê','Ë','Ì','Í','Î','Ï','Ò','Ó','Ô','Õ','Ö','Ù','Ú','Û','Ü','Ý','à','á','â','ã','ä','å','ç','è','é','ê','ë','#','+'); 
		$allowed = array('A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e','e','sharp','plus');
		$file = str_replace($notAllowedChars, $allowed, $file);
		
		$file = preg_replace('/([^a-z0-9]+)/i', '_', $file);
		return strtolower($file);
	}

	function slug_url($file) {
		$notAllowedChars = array('À','Á','Â','Ã','Ä','Å','Ç','È','É','Ê','Ë','Ì','Í','Î','Ï','Ò','Ó','Ô','Õ','Ö','Ù','Ú','Û','Ü','Ý','à','á','â','ã','ä','å','ç','è','é','ê','ë','#','+'); 
		$allowed = array('A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e','e','sharp','plus');
		$file = str_replace($notAllowedChars, $allowed, $file);
		
		$file = preg_replace('/([^a-z0-9]+)/i', '-', $file);
		return strtolower($file);
	}

	function getFilesExt($dir, $ext) {
		$files = scandir($dir);
		$files_json = array();
		foreach ($files as $f) {
			if (substr_count($f, $ext)) $files_json[] = str_replace($ext, '', $f); 
		}
		return $files_json;
	}

	function repeatToList($list) {
		$out = array();
		foreach ($list as $k => $l) {
			$id = (int)$l['id'];
			if (empty($l['id_repeat']) && $l['type'] !== 'repeat') {
				$out[$id] = $l;
			} elseif ($l['type'] === 'repeat') {
				$out[$id] = $l;
				foreach ($list as $k2 => $l2) {
					$id2 = (int)$l2['id'];
					$id_repeat = $l2['id_repeat'];
					$ord_repeat = (int)$l2['ord_repeat'];
					if (!empty($id_repeat) && $id === (int)$id_repeat) {
						$out[$id]['child'][$ord_repeat][$id2] = $l2;
					}
				}
			}
		}
		//var_dump($out);die();
		return $out;
	}

	function check_type_mime($type) {
		$out = false;
		foreach ($GLOBALS['type_mime'] as $k => $tm) {
			if ($tm['type'] == $type) $out = $tm['ext'];
		}
		return $out;
	}

	function check_size_file($size) {
		return (int)$size < (UPLOAD_SIZE*1000000) ? true : false;
	}
	
	function bg_img($file) {
		return 'style="background-image: url('.$file.ts().');"';
	}

	function up_img($id) {
		$img = read('img', 'status = 1 AND id='.$id.' ORDER BY date, id DESC');
		return count($img) > 0 ? UPLOAD_URL.'img/'.$img[0]['name'].ts() : false;
	}

	function price($price) {
		return number_format($price, 2, ',', ' ').'€';
	}

	function price2($price) {
		return number_format($price, 0, '', ' ').'€';
	}

	function arr_find($find, $arr) {
		if (is_array($find) && is_array($arr)) {
			foreach ($arr as $k => $a) {
				if (!empty($a[key($find)]) && $a[key($find)] == $find[key($find)]) return $a;
			}
		}
		return false;
	}

	function is_json($string) {
		json_decode($string);
		return (json_last_error() == JSON_ERROR_NONE);
	}

	
?>