function setCookie(key, value) {
    var expires = new Date();
    expires.setTime(expires.getTime() + (1 * 24 * 60 * 60 * 1000));
    document.cookie = key + '=' + value + ';expires=' + expires.toUTCString();
}

function getCookie(key) {
    var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');
    return keyValue ? keyValue[2] : null;
}

function formatMillier (nombre){
    nombre += '';
    var sep = ' ';
    var reg = /(\d+)(\d{3})/;
    while( reg.test( nombre)) {
      nombre = nombre.replace( reg, '$1' +sep +'$2');
    }
    return nombre;
}

function goTo(element) {
	$('html, body').animate({scrollTop: ($(element).offset().top)-50}, 1000, function(){});
}

// alert js 
function alert_js(type, msg, time=8000) {
	if ($('.alert_container_js').length) {
		$('.alert_container_js').show();
		$('.alert_container_js .alert').addClass(type);
		$('.alert_container_js .msg').html(msg);
		setTimeout(function() {
			$('.alert_container_js').hide();
		}, time);
	}
}

var h = {};

$(function() {

	// INIT Globals
	var on = "on";
	var speed = 800;

	// Save src of Video YouTube on data-src
	$("iframe[src*=youtube]").length > 0 ? $("iframe[src*=youtube]").each(function() {$(this).attr("data-src", $(this).attr("src"));}) : 0;

	// FUNCTIONS Helpers
	h.goTo = function(e) {
		$("html, body").animate({scrollTop: e.offset().top-50}, speed);
	}

	h.callFile = function(file, id) {
		$.get(file, function(res) {res.length > 0 ? document.getElementById(id).innerHTML = res : 0;});
	}

	h.randomRange = function(min,max) {
	    return Math.floor(Math.random()*(max-min+1)+min);
	}
	
	h.clickOn = function(e,c) {
		e.parent().find(">li").removeClass(c);
		e.addClass(c);
	}

	h.inOut = function(jsWidgetName, onEvent, callback) {
		$("html").on(onEvent,"[data-"+jsWidgetName+"-anchor]", function(e) {
			var anchorElt = $(this);
			$("[data-"+jsWidgetName+"-action="+anchorElt.attr("data-"+jsWidgetName+"-anchor")+"]").each(function(i,v) {
				callback && typeof(callback) === "function" ? callback(anchorElt, $(this)) : "";
			});
		});
	}

	/* LISTENERS */
	
	/* on Example: data-on-anchor="popin1" data-on-action="popin1" */
	h.inOut("on", "click", function(anchorElt, actionElt) {
		actionElt.toggleClass(on);
		// Stop Video YouTube on Close
		if ($("iframe[data-src*=youtube]").length > 0) {
			var videoElt = actionElt.find("iframe[data-src*=youtube]");
			actionElt.hasClass("on") ? videoElt.attr("src") == "" ? videoElt.attr("src",videoElt.attr("data-src")) : "" : videoElt.attr("src","");
		}
	});

	h.inOut("addClass", "click", function(anchorElt, actionElt) {actionElt.addClass(on);});
	h.inOut("removeClass", "click", function(anchorElt, actionElt) {actionElt.removeClass(on);});
	
	h.inOut("triggerClick", "click", function(anchorElt, actionElt) {actionElt.trigger('click');});
	h.inOut("triggerChange", "change", function(anchorElt, actionElt) {actionElt.trigger('click');});
	
	/* goTo Example: data-goTo-anchor="goto1" data-goTo-action="goto1" */
	h.inOut("goTo", "click", function(anchorElt, actionElt) {h.goTo(actionElt);});

	/* slider */
	$("[data-slider]").length > 0 ? $("[data-slider]").bxSlider() : "";
	
	/* tabs Example: data-tabs-anchor="menu1" data-tabs-action="menu1" */
	$("html").on("click","ul[data-tabs-anchor]>li:not(."+on+")", function(e) {
		h.clickOn($(this),on);
		$("[data-tabs-action="+$(this).parent().attr("data-tabs-anchor")+"]").find(">*").removeClass(on).eq($(this).index()).addClass(on);
	});
	
	/* clickon Example: data-accordeon="accordeon1" */
	$("html").on("click","ul[data-accordeon]>li h3", function(e) {
		$(this).parents('li').toggleClass(on);
	});

	$("html").on("click","ul[data-clickon]>li", function(e) {
		h.clickOn($(this),on);
	});
	
	// Animate
    var animDelay = 0;
    $("[data-anim]").each(function(i) {
		$(this).bind("inview", function(e, on) {
			var animName = $(this).attr("data-anim");
			on ? $(this).delay(animDelay).queue(function(){$(this).addClass("animated "+animName).dequeue();}) : '';
		});
	});

	// checkbox required
	$('.form_checkbox_required').submit(function(e) {
		var count = 0;
		$('.checkbox_required').each(function() {
			this.checked ? count++ : null;
		});
		//console.log(count);
		if ((count != parseInt($('.checkbox_required').length))) { // all checkbox is checked
			alert_js('error', 'Veuillez cocher toutes les cases.', 8000)
			return false;
		} else {
			return true;
		}
	});

});
