<?php
	if (!$connect) go_die(URL.'connexion'); // need connected to display homepage

	$read_questions = read('questions', 'status=1 and id_institution='.$instit['id']);
	//var_dump($read_questions);
	if (!empty($read_questions))
	$read_questions_index = array_index($read_questions, 'id');
	//var_dump($read_questions_index);

	$question_moy = read2('select avg(note) as moy, id_question from '.PREFIX_DB.'feedbacks_questions where id_institution='.$instit['id'].' group by id_question');
	//var_dump($question_moy);
	if (!empty($question_moy))
	$question_moy = array_index($question_moy, 'id_question');
	//var_dump($question_moy);

	$last_fb = read('feedbacks','id_institution='.$instit['id'].' order by date desc limit 3');

	// stats
	$read_recipients = read('recipients', 'status=1 and id_institution='.$instit['id']);
	$nb_form = 0;
	foreach ($read_recipients as $k => $r) {
		$list_expl = explode(',',$r['list']);
		//var_dump($list_expl);
		$nb_form += count($list_expl);
	}

	$msg_in = read('feedbacks','status=1 and id_institution='.$instit['id']);
	$msg_in = count($msg_in);

	$nb_google = read('google','status=1 and id_institution='.$instit['id']);
	$nb_google = count($nb_google);

	$nb_just = read_join(array('feedbacks' => 'id','feedbacks_questions' => 'id_feedback'), 't1.comment is null and t1.status=1 and t1.id_institution='.$instit['id'].' and t2.id_institution='.$instit['id']);
	$nb_just = count($nb_just);

?>
<?php require_once 'head.php'; ?>

<div class="flex mt30">
	<?php require_once 'nav.php'; ?>
	<div class="home col-9 pl30 pr40">
		<div class="home_top flex">
			<div class="col-6 box">
				<h2 class="flex">
					<img class="mr5" width="30" src="<?=TPL_IMG?>pictos/graph.png" alt="Répartition de l'activité"> Répartition de l'activité
				</h2>
				<div class="sep"></div>
				<div id="piechart" class="w50r h30r"></div>
			</div>
			<div class="home_top col-6 box ml40">
				<h2 class="flex">
					<img class="mr5" width="30" src="<?=TPL_IMG?>pictos/graph.png" alt="Évolution de l'activité"> Évolution de l'activité
				</h2>
				<div class="sep"></div>
				<div id="line_top_x"></div>
			</div>
		</div>
		<div class="flex mt30">
			<div class="col-4 box">
				<h2 class="flex">
					<img class="mr5" width="30" src="<?=TPL_IMG?>pictos/graph.png" alt="Mes dernières notes"> Mes dernières notes
				</h2>
				<?php if (!empty($read_questions_index)) : ?>
				<ul class="last_notes mt20">
					<?php $sum_moy = 0; foreach ($read_questions_index  as $i => $q) : ?>
						<?php if ($i <= 4) : $sum_moy += round($question_moy[$i]['moy']*2)/2; ?>
							<li class="mb5">
								<span class="flex aic jcsb">
									<span class=""><?=$q['title']?> : <?=round($question_moy[$i]['moy'],2)?>/5</span>
									<span class="icon-medium flex mr20"><?=icons_nb(round($question_moy[$i]['moy']*2)/2)?></span>
								</span>
							</li>
						<?php endif ?>
					<?php endforeach ?>
					<li class="mt15">
						<span class="flex aic jcsb">
							<span class="">Moyenne : <?=round($sum_moy/4,1)?>/5</span>
						</span>
					</li>
				</ul>
				<div class="flex jce mt5">
					<a class="btn btn3" href="<?=URL.'avis-interne?type=all'?>" title="Détails">Voir détails</a>
				</div>
				<?php else : ?>
					<div class="fc h100 mtn20">Aucune donnée</div>
				<?php endif ?>
			</div>
			<div class="col-4 box ml15">
				<h2 class="flex">
					<img class="mr5" width="30" src="<?=TPL_IMG?>pictos/graph.png" alt="Mes derniers feedback"> Mes derniers feedback
				</h2>
				<?php if (!empty($last_fb)) : ?>
				<ul class="last_feedback mt15">
					<?php foreach ($last_fb as $i => $l) : ?>
					<li class="flex aic w100 mb5">
						<span class="last_feedback_left w20r flex fw aic jcsb">
							<span class="flex aic jcsb w100">
								<span class="last_feedback_name t13"><?=$l['name_customer']?></span>
								<span class="last_feedback_date t9 pr30"><?=date('d/m/Y', strtotime($l['date']))?></span>
							</span>
							<span class="icon-medium flex mtb5"><?=icons_nb($l['moy'])?></span>
						</span>
						<span class="pl5">
							<a class="btn btn3" href="<?=URL.'avis-interne?type=all&id='.$l['id']?>" title="Consulter">Consulter</a>
						</span>
					</li>
					<?php endforeach ?>
				</ul>
				<?php else : ?>
					<div class="fc h100 mtn20">Aucune donnée</div>
				<?php endif ?>
			</div>
			<div class="col-4 box ml15">
				<h2 class="flex">Activités récentes</h2>
				<ul class="new_activities mt10">
					<li class="mb5"><span class="dib t22 bold center w5r pr5"><?=$nb_form?></span>formulaires envoyés</li>
					<li class="mb5"><span class="dib t22 bold center w5r pr5"><?=$msg_in?></span>messages reçus</li>
					<li class="mb5"><span class="dib t22 bold center w5r pr5"><?=$nb_google?></span>redirection Google</li>
					<li class="mb5"><span class="dib t22 bold center w5r pr5"><?=$nb_just?></span>juste notés</li>
				</ul>
			</div>
		</div>
	</div>
</div>

<?php require_once 'foot.php'; ?>

<script>
	google.charts.load('current', {'packages':['corechart']});
	google.charts.setOnLoadCallback(drawChart);
	function drawChart() {
		var data = google.visualization.arrayToDataTable([
			['Task', 'Hours per Day'],
			['Non Ouverts',     <?=$nb_form?>],
			['Redirection Google', <?=$nb_google?>],
			['Messages reçus',  <?=$msg_in?>],
			['Juste notés', <?=$nb_just?>],
		]);

		var options = {
			title: '',
			colors:['#77b6e9','#f2e7fe','#c8fff4','#dbb2ff'],
			pieSliceBorderColor: 'transparent',
			pieSliceTextStyle: {color: 'black'}
		};

		var chart = new google.visualization.PieChart(document.getElementById('piechart'));
		chart.draw(data, options);
	}

	google.charts.load('current', {'packages':['line']});
	google.charts.setOnLoadCallback(drawChart2);

    function drawChart2() {

      var data = new google.visualization.DataTable();
      data.addColumn('number', 'Date');
      data.addColumn('number', 'Formulaires envoyés');
      data.addColumn('number', 'Redirection Google');
      data.addColumn('number', 'Messages reçus');
      data.addColumn('number', 'Juste notés');

      data.addRows([
        [<?=date('d', strtotime(date('Y-m-d').' -3 days'))?>,  <?=$nb_form?>, <?=$nb_google?>, <?=$msg_in?>, <?=$nb_just?>],
        [<?=date('d', strtotime(date('Y-m-d').' -2 days'))?>,  <?=$nb_form?>, <?=$nb_google?>, <?=$msg_in?>, <?=$nb_just?>],
        [<?=date('d', strtotime(date('Y-m-d').' -1 day'))?>,  <?=$nb_form?>, <?=$nb_google?>, <?=$msg_in?>, <?=$nb_just?>],
        [<?=date('d')?>,  <?=$nb_form?>, <?=$nb_google?>, <?=$msg_in?>, <?=$nb_just?>]
      ]);

      var options = {
        chart: {
          title: ''
        },
		colors:['#77b6e9','#f2e7fe','#c8fff4','#dbb2ff'],
        width: 500,
        height: 300,
        axes: {
          x: {
            0: {side: 'bottom'}
          }
        }
      };

      var chart = new google.charts.Line(document.getElementById('line_top_x'));
      chart.draw(data, google.charts.Line.convertOptions(options));
    }
</script>