<?php if (PROD) ob_start("ob_html_compress"); ?>
<!doctype html>
<html lang="<?=$lang?>">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width,initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	
	<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Expires" content="0">
	
	<title><?=$seo_title?> | <?=NAME?></title>
	<meta name="description" content="<?=$seo_desc?>">
	<meta name="author" content="<?=NAME?>">
	<meta name="robots" content="index, follow">
	<meta name="msapplication-TileColor" content="<?=COLOR?>">
	<meta name="msapplication-TileImage" content="<?=TPL_IMG?>favicon.png">
	<meta name="theme-color" content="<?=COLOR?>">

	<link rel="canonical" href="<?=CANONICAL?>" />
	<?php if (0) : ?>
	<link rel="alternate" href="<?=CANONICAL?>" hreflang="<?=$lang?>" />
	<?php endif ?>

	<meta property="og:locale" content="fr_FR" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="<?=$seo_title?>" />
	<meta property="og:description" content="<?=$seo_desc?>" />
	<meta property="og:url" content="<?=URL_PROD?>" />
	<meta property="og:site_name" content="<?=NAME?>" />
	<meta property="og:image" content="<?=TPL_IMG?>logo.png" />
	<meta property="og:image:secure_url" content="<?=TPL_IMG?>logo.png" />

	<meta name="twitter:card" content="summary_large_image" />
	<meta name="twitter:title" content="<?=$seo_title?>" />
	<meta name="twitter:description" content="<?=$seo_desc?>" />
	<meta name="twitter:site" content="<?=URL_PROD?>" />
	<meta name="twitter:image" content="<?=TPL_IMG?>logo.png" />
	<meta name="twitter:creator" content="@<?=NAME?>" />
	
	<link rel="shortcut icon" type="image/x-icon" href="<?=TPL_IMG?>favicon.png">
	<link rel="apple-touch-icon" sizes="180x180" href="<?=TPL_IMG?>favicon-apple.png">
	<link rel="icon" type="image/png" href="<?=TPL_IMG?>favicon.png">
	
	<link rel="stylesheet" type="text/css" href="<?=ASSETS_CSS?>jquery-ui.min.css">
	<link rel="stylesheet" type="text/css" href="<?=ASSETS_CSS?>animate.min.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.tilgo.fr/css/base.min.css<?=ts()?>">
	<link rel="stylesheet" type="text/css" href="<?=TPL_CSS?>style.css<?=ts()?>">	
	<?=$hook_head ?? ''?>
	
</head>

<body data-goTo-action="go_top" 
class="my_scrollbar <?=$body_page?><?=!empty($connect)?' connected':''?><?=!empty($page_name)?' '.$page_name:''?><?=!empty($page_id)?' page_'.$page_id:''?>">

<?php require_once 'svg.php'; ?>
<?php require_once 'header.php'; ?>