$(function() {
	
	$('html').on('click', '.one_on > div', function(e) {
		var me = $(this);
		me.parent().find('div').removeClass('on');
		me.addClass('on');
	});
	
	$('html').on('click', '.matable tbody tr', function(e) {
		var me = $(this);
		$('.matable tbody tr').removeClass('on');
		me.addClass('on');
	});


	$('html').on('keyup focus', '.autocompletion input[type="text"]', function(e) {
		var keyword = $(this).val().toLowerCase();
		var autocompletion = $(this).parents('.autocompletion').find('.autocompletion_c');
		var autocompletion_li = autocompletion.find('ul li');
		if (keyword.length >= 2) {
			autocompletion_li.hide(); // default
			var n = 0;
			autocompletion_li.each(function(li) {
				var text = $(this).text().toLowerCase();
				//console.log(text.indexOf(keyword));
				if (text.indexOf(keyword) > -1) {
					autocompletion.show();
					$(this).show();
					n++;
				}
				else {
					$(this).hide();
				}
			});
			if (n === 0) autocompletion.hide();
		} else {
			autocompletion.hide();
		}
	});
	$('html').on('click', '.autocompletion_c ul li', function(e) {
		var text = $(this).text();
		var autocompletion = $(this).parents('.autocompletion');
		autocompletion.find('input[type="text"]').val(text);
		autocompletion.find('.autocompletion_c').hide();
	});

	var xhr = null;

	$('html').on('keyup focus', '.cities input[type="text"]', function(e) {
		var keyword = $(this).val().toLowerCase();	
		if (keyword.length >= 2) {
			var cities = $(this).parents('.cities').find('.cities_c');
			var settings = {
				"url": "https://api.tilgo.fr/cp?key="+keyword,
				"method": "GET",
				"timeout": 0,
				"beforeSend" : function() {          
					if (xhr != null) xhr.abort();
				}
			};
			
			xhr = $.ajax(settings).done(function (res) {
				//console.log(res);
				cities.show();
				var out = '';
				res.forEach(function(e) {
					out += '<li>'+e[0]+' ('+e[1]+')</li>';
				});
				cities.find('ul').html(out);
			});
		}
	});

	$('html').on('click', '.view_pass', function(e) {
		var input = $(this).parents('fieldset').find('input');
		if (input.attr('type') == 'password') {
			input.attr('type','text');
			$('.eye').hide();
			$('.eye_slash').show();
		} else if (input.attr('type') == 'text') {
			input.attr('type','password');
			$('.eye').show();
			$('.eye_slash').hide();
		}
	});
	
	/* AJAX 
	$.ajax({
		url: "ajax.php",
		type: "GET",
		data: {id:id},
		success: function(resp) {
			//console.log(resp);
			var obj = JSON.parse(resp);
			//console.log(obj);
		},
		error:function(){
			
		}
	}); 
	
	var settings = {
		"url": url, 
		"method": POST, "timeout": 0,
		"headers": {"Authorization": "token "+token}
	};
	$.ajax(settings).done(function (response) {
		//console.log(response);
	});*/

	/* SCROLL EVENTS */
	function fixDiv() {
		//var elt_offset = $('.element').offset().top;
		var header_height = $('header').height();
		$(window).scrollTop() >= header_height?$('.go-top').removeClass('on'):$('.go-top').addClass('on');
		$(window).scrollTop() >= header_height?$('body.index header').addClass('on'):$('body.index header').removeClass('on');
	}
	$(window).scroll(fixDiv);
	fixDiv();

	/* cookie */
	if (getCookie("display_cookie") == "on") {
		$('footer').addClass("cookie_off");
	} else {
		$('footer').removeClass("cookie_off");
		$('.cookies-c').removeClass("on");
	}

	$('html').on('click', '.cookies-close', function(e) {
		setCookie("display_cookie", "on");
		$('footer').addClass("cookie_off");
	});
	
	/* isotope */
	var $grid = $('.grid').isotope({
		itemSelector: '.grid_i',
		layoutMode: 'fitRows'
	});

	$("html").on("click", '.isotope ul li', function(e) {
		var data_filter = $(this).attr('data-filter');
		$grid.isotope({filter: data_filter});
	});

	var filters = [];
	$("html").on("click", '.filters [data-filter]', function(e) {
		var my_filter = $(this).attr('data-filter');
		filters.indexOf(my_filter) < 0 && $(this).is(':checked') ? filters.push(my_filter) : null;
		filters.indexOf(my_filter) >= 0 && !$(this).is(':checked') ? filters.splice(filters.indexOf(my_filter), 1) : null;
		//console.log(filters);
		//$grid.isotope({filter: filters.join(',')});
		reset_pagination();
	});
	
	/* isotope pagination */
	var nb_item_per_page = 4;

	function reset_pagination() {
		var current_page = 1;
		var max_page = 1;
		var offset_item = 1;
		var nb_visible = $('.grid_i:visible').length;
		//console.log(filters);

		var wl = [];
		$('.grid_i').each(function() {
			var id = parseInt($(this).attr('data-id'));
			//console.log(id);
			var c1 = false;
			if (filters.length > 0) {	
				filters.forEach(function(e) {
					var my_class = e.replace('.','');
					//console.log(my_class);
					if ($('.grid_i[data-id="'+id+'"]').hasClass(my_class)) c1 = true;
				});
				if (c1) wl.push(id);
			}
		});
		if (filters.length > 0) {	
			//console.log(wl);
			nb_visible = wl.length;
			//console.log(nb_visible);
		}

		$grid.isotope({ filter: function() {
				var id = parseInt($(this).attr('data-id'));
				//console.log(id);
				if (filters.length > 0) {	
					if (wl.indexOf(id) >= 0) return true;
				} else {
					return id < nb_item_per_page;
				}
			}
		});

		max_page = Math.ceil(nb_visible / nb_item_per_page);
		$('.grid_pages').html(''); // reset list pages
		for (var i=1;i<=max_page;i++) {
			var add_class = (i==current_page) ? 'bold' : 'underline cp'; 
			$('.grid_pages').append('<div data-page="'+i+'" class="page_elt dib mlr5 '+add_class+' ">'+i+'</div>');
		}

		$("html").on("click", '.page_elt.cp', function(e) { // click on a page
			$('.page_elt').removeClass('bold').addClass('underline cp');
			$(this).removeClass('underline cp').addClass('bold');
			current_page = parseInt($(this).attr('data-page'));
			offset_item = (nb_item_per_page * current_page) - nb_item_per_page;
			//console.log(offset_item);
			$grid.isotope({ filter: function() {
					var id = parseInt($(this).attr('data-id'));
					//console.log(id);

					var c1 = false;		
					if (filters.length > 0) {	
						filters.forEach(function(e) {
							var my_class = e.replace('.','');
							//console.log(my_class);
							if ($('.grid_i[data-id="'+id+'"]').hasClass(my_class)) c1 = true;
						});
					} else {
						c1 = true;
					}

					return c1 && id >= offset_item && id < (offset_item+nb_item_per_page);
				}
			});
		});
	}

	reset_pagination();
	
	/* Slider Range */
	if ($(".slider_range").length) {
		var slider_range = $(".slider_range").slider({
			range: true,
			min: 300,
			max: 2000,
			step: 50,
			values: [500, 1000],
			stop: function (e, ui) {
				//refreshSalary();
				//console.log(min);
			},
			slide: function(event, ui) {
				$('.ui-slider-handle:nth-child(2) span.value').text(ui.values[0]+' €');
				$('.ui-slider-handle:nth-child(3) span.value').text(ui.values[1]+' €');
				if ($("#min_salary").length) $('#min_salary').val(ui.values[0]);
				if ($("#max_salary").length) $('#max_salary').val(ui.values[1]);
			}
		});
		$('.ui-slider-handle:nth-child(2)').html('<span class="label">Min.</span>');
		$('.ui-slider-handle:nth-child(3)').html('<span class="label">Max.</span>');
		$('.ui-slider-handle:nth-child(2) span.label').after('<span class="value">'+slider_range.slider("values", 0)+' €</span>');
		$('.ui-slider-handle:nth-child(3) span.label').after('<span class="value">'+slider_range.slider("values", 1)+' €</span>');
	}
	
	/* counter */
	if ($('.count_number').length) {
		$('.count_number').each(function(i,e) {
				var kf_counter = 0;
				$(e).bind("inview", function(e, on) {
						var count_duration = 1200;
						if (on && kf_counter == 0) {
								$(this).prop('Counter',-1).animate({
										Counter: $(this).attr('data-count') ?  $(this).attr('data-count').replace(' ','') : $(this).text().replace(' ','')
								}, {
										duration: count_duration,
										easing: 'swing',
										step: function (now) {
												$(this).text(formatMillier(Math.ceil(now)));
										}
								});
								kf_counter++;
						}
				});
		});
	}

	//$('[name="size_company[toutes_tailles_d_entreprises]"]').trigger('click');
	//$('[data-on-anchor="size_company"]').trigger('click');

});

/* parallax */
function isInViewport(node) {
	var rect = node.getBoundingClientRect();
	return (
	  (rect.height > 0 || rect.width > 0) &&
	  rect.bottom >= 0 &&
	  rect.right >= 0 &&
	  rect.top <= (window.innerHeight || document.documentElement.clientHeight) &&
	  rect.left <= (window.innerWidth || document.documentElement.clientWidth)
	);
}

$(window).scroll(function() {
	var scrolled = $(window).scrollTop();
	if ($('.parallax').length) {
		$('.parallax').each(function(index, element) {
			var initY = $(this).offset().top;
			var height = $(this).height();
			var endY  = initY + $(this).height();
			if (isInViewport(this)) {
				var diff = scrolled - initY;
				var ratio = Math.round((diff / height) * 100);
				$(this).css('background-position-y',' ' + parseInt(-(ratio * 1.5)) + 'px');
			}
		});
	}
});

