<?php

	function get_curl($url, $header=array('Content-Type' => 'application/json; charset=UTF-8','Accept' => 'application/json')) {
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_HTTPHEADER => $header,
			CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows; U; Windows NT 5.1; fr-FR; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13'
		));
		$response = curl_exec($curl);
		//var_dump($response);die();
		curl_close($curl);
		return is_json($response) ? json_decode($response, true) : $response;
	}
	
	function post_curl($url, $header=array('Content-Type' => 'application/json; charset=UTF-8','Accept' => 'application/json'), $json=array()) {
		$ch1 = curl_init($url);
		curl_setopt($ch1, CURLOPT_POST, 1);
		curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode($json));
		curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($ch1, CURLOPT_HTTPHEADER, array('Authorization: Basic '.$autho,'Content-Type: application/json'));
		curl_setopt($ch1, CURLOPT_HTTPHEADER, $header); 
		$result = curl_exec($ch1);
		$jsonFinal = json_decode($result, true);
		curl_close($ch1);
		return $jsonFinal;
	}

	function put_curl($url, $header=array('Content-Type' => 'application/json; charset=UTF-8','Accept' => 'application/json'), $json=array()) {
		$curl = curl_init();
		curl_setopt_array($curl, 
			array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "PUT",
				CURLOPT_HTTPHEADER => $header,
				CURLOPT_POSTFIELDS => json_encode($json)
			)
		);
		$response = curl_exec($curl);
		curl_close($curl);
		return $response;
	}

	function delete_curl($url, $header=array('Content-Type' => 'application/json; charset=UTF-8','Accept' => 'application/json'), $json=array()) {
		$curl = curl_init();
		curl_setopt_array($curl, 
			array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "DELETE",
				CURLOPT_HTTPHEADER => $header,
				CURLOPT_POSTFIELDS => json_encode($json)
			)
		);
		$response = curl_exec($curl);
		curl_close($curl);
		return $response;
	}

?>